﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" Title="" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="UTorrentLib" Namespace="UTorrentLib" Assembly="UTorrentLib" %>
<%@ Import Namespace="System.Data" %>

<script runat="server">
    private TorrentSession torrentsession;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Convert.ToBoolean(Application["isready"]) == true)
        {
            Timer1.Enabled = true;

            DropDownList1.Visible = true;

            LinkButton1.Visible = true;

            if (Page.IsPostBack == false)
            {
                UpdateTorrentList("Downloading", false);
            }

            if (CollapsiblePanelExtender2.ClientState == "true")
            {
                GridView2.Visible = false;
            }
            else
            {
                GridView2.Visible = true;
            }
        }
        else
        {
            Timer1.Enabled = false;

            DropDownList1.Visible = false;

            LinkButton1.Visible = false;
        }
    }

    private void UpdateTorrentList(string torrenttype, bool update)
    {
        if (update == false)
        {
            GridView1.SelectedIndex = -1;

            ViewState["TORRENTS_SORT"] = null;

            ViewState["TORRENTS_PAGEINDEX"] = null;

            ViewState["TORRENT_SORT"] = null;

            ViewState["TORRENT_PAGEINDEX"] = null;

            GridView2.DataSource = null;
            GridView2.DataBind();

            LinkButton3.Text = string.Empty;
        }

        torrentsession = Session["TorrentSession"] as TorrentSession;

        torrentsession.UpdateLists();

        if (torrentsession != null)
        {
            UTorrentList torrentlist;

            switch (torrenttype)
            {
                case "Seeding":
                    torrentlist = torrentsession.TorrentsSeeding;

                    break;
                case "Downloading":
                    torrentlist = torrentsession.TorrentsDownloading;

                    break;
                case "Finished":
                    torrentlist = torrentsession.TorrentsFinished;

                    break;
                case "All":
                default:
                    torrentlist = torrentsession.TorrentsAll;

                    break;
            }

            Session["TorrentList"] = torrentlist;

            if (torrentlist.Count > 0)
            {
                LinkButton2.Text = string.Format("Torrent Count: {0}, Download Speed: {1}, Upload Speed: {2}", torrentlist.Count, torrentsession.fDownloadSpeed, torrentsession.fUploadSpeed);
            }
            else
            {
                LinkButton2.Text = string.Format("Download Speed: {0}, Upload Speed: {1}", torrentsession.fDownloadSpeed, torrentsession.fUploadSpeed);
            }

            if (CollapsiblePanelExtender1.ClientState != "true")
            {
                DataTable datatable = new DataTable();
                datatable.Columns.Add("Name", Type.GetType("System.String"));
                datatable.Columns.Add("Label", Type.GetType("System.String"));
                datatable.Columns.Add("Hash", Type.GetType("System.String"));
                datatable.Columns.Add("Status", Type.GetType("System.String"));
                datatable.Columns.Add("Size", Type.GetType("System.Int64"));
                datatable.Columns.Add("fSize", Type.GetType("System.String"));
                datatable.Columns.Add("Progress", Type.GetType("System.Int32"));
                datatable.Columns.Add("Remaining", Type.GetType("System.Int64"));
                datatable.Columns.Add("Downloaded", Type.GetType("System.Int64"));
                datatable.Columns.Add("Uploaded", Type.GetType("System.Int64"));
                datatable.Columns.Add("Ratio", Type.GetType("System.Decimal"));
                datatable.Columns.Add("DownloadSpeed", Type.GetType("System.Int32"));
                datatable.Columns.Add("fDownloadSpeed", Type.GetType("System.String"));
                datatable.Columns.Add("UploadSpeed", Type.GetType("System.Int32"));
                datatable.Columns.Add("fUploadSpeed", Type.GetType("System.String"));
                datatable.Columns.Add("ETA", Type.GetType("System.Int32"));
                datatable.Columns.Add("fETA", Type.GetType("System.String"));
                datatable.Columns.Add("PeersConnected", Type.GetType("System.Int32"));
                datatable.Columns.Add("PeersInSwarm", Type.GetType("System.Int32"));
                datatable.Columns.Add("fPeers", Type.GetType("System.String"));
                datatable.Columns.Add("SeedsConnected", Type.GetType("System.Int32"));
                datatable.Columns.Add("SeedsInSwarm", Type.GetType("System.Int32"));
                datatable.Columns.Add("fSeeds", Type.GetType("System.String"));
                datatable.Columns.Add("Availability", Type.GetType("System.Decimal"));

                foreach (UTorrent torrent in torrentlist)
                {
                    DataRow datarow = datatable.NewRow();
                    datarow["Name"] = torrent.Name;
                    datarow["Label"] = torrent.Label;
                    datarow["Hash"] = torrent.Hash;
                    datarow["Status"] = torrent.Status;
                    datarow["Size"] = torrent.Size;
                    datarow["fSize"] = torrent.fSize;
                    datarow["Progress"] = torrent.Progress;
                    datarow["Remaining"] = torrent.Remaining;
                    datarow["Downloaded"] = torrent.Downloaded;
                    datarow["Uploaded"] = torrent.Uploaded;
                    datarow["Ratio"] = torrent.Ratio / Convert.ToDouble(1000);
                    datarow["DownloadSpeed"] = torrent.DownloadSpeed;
                    datarow["fDownloadSpeed"] = torrent.fDownloadSpeed;
                    datarow["UploadSpeed"] = torrent.UploadSpeed;
                    datarow["fUploadSpeed"] = torrent.fUploadSpeed;
                    datarow["ETA"] = torrent.ETA;
                    datarow["fETA"] = torrent.fETA;
                    datarow["PeersConnected"] = torrent.PeersConnected;
                    datarow["PeersInSwarm"] = torrent.PeersInSwarm;
                    datarow["fPeers"] = torrent.fPeers;
                    datarow["SeedsConnected"] = torrent.SeedsConnected;
                    datarow["SeedsInSwarm"] = torrent.SeedsInSwarm;
                    datarow["fSeeds"] = torrent.fSeeds;
                    datarow["Availability"] = torrent.Availability / Convert.ToDouble(100000);

                    datatable.Rows.Add(datarow);
                }

                DataView dataview = new DataView(datatable, string.Empty, Convert.ToString(ViewState["TORRENTS_SORT"]), DataViewRowState.CurrentRows);

                if (ViewState["TORRENTS_PAGEINDEX"] != null)
                {
                    GridView1.PageIndex = Convert.ToInt32(ViewState["TORRENTS_PAGEINDEX"]);
                }

                GridView1.DataSource = dataview.ToTable();

                GridView1.DataBind();
            }
            else
            {
                if (LinkButton2.Text.IndexOf(" (click to show details)") == -1)
                {
                    LinkButton2.Text += " (click to show details)";
                }
            }

            if (GridView1.SelectedIndex > -1)
            {
                UpdateFileList();
            }
        }
    }

    private void UpdateFileList()
    {
        if (CollapsiblePanelExtender2.ClientState == "false")
        {
            if (GridView1.DataKeys.Count > GridView1.SelectedIndex)
            {
                UTorrentList torrents = Session["TorrentList"] as UTorrentList;

                string hash = Convert.ToString(GridView1.DataKeys[GridView1.SelectedIndex].Values["Hash"]);

                foreach (UTorrent torrent in torrents)
                {
                    if (hash.Equals(torrent.Hash))
                    {
                        bool found = false;
                        try
                        {
                            torrent.LoadFiles();

                            found = true;
                        }
                        catch
                        {
                        }

                        if (found == true)
                        {
                            LinkButton3.Text = string.Format("Details for {0}: {1} file(s)", torrent.Name, torrent.m_Files.Count);

                            DataTable datatable = new DataTable();
                            datatable.Columns.Add("FileName", Type.GetType("System.String"));
                            datatable.Columns.Add("FileSize", Type.GetType("System.Int64"));
                            datatable.Columns.Add("fFileSize", Type.GetType("System.String"));
                            datatable.Columns.Add("Downloaded", Type.GetType("System.Int64"));
                            datatable.Columns.Add("fDownloaded", Type.GetType("System.String"));
                            datatable.Columns.Add("Percent", Type.GetType("System.Int32"));
                            datatable.Columns.Add("fPercent", Type.GetType("System.String"));
                            datatable.Columns.Add("Priority", Type.GetType("System.String"));
                            datatable.Columns.Add("fPriority", Type.GetType("System.String"));

                            foreach (UTorrentFile utorrentfile in torrent.m_Files)
                            {
                                DataRow datarow = datatable.NewRow();
                                datarow["FileName"] = utorrentfile.FileName;
                                datarow["FileSize"] = utorrentfile.FileSize;
                                datarow["fFileSize"] = utorrentfile.fFileSize;
                                datarow["Downloaded"] = utorrentfile.Downloaded;
                                datarow["fDownloaded"] = utorrentfile.fDownloaded;
                                datarow["Percent"] = utorrentfile.Percent;
                                datarow["fPercent"] = utorrentfile.fPercent;
                                datarow["Priority"] = utorrentfile.Priority;
                                datarow["fPriority"] = utorrentfile.fPriority;

                                datatable.Rows.Add(datarow);
                            }

                            DataView dataview = new DataView(datatable, string.Empty, Convert.ToString(ViewState["TORRENT_SORT"]), DataViewRowState.CurrentRows);

                            if (ViewState["TORRENT_PAGEINDEX"] != null)
                            {
                                GridView2.PageIndex = Convert.ToInt32(ViewState["TORRENT_PAGEINDEX"]);
                            }

                            GridView2.DataSource = dataview.ToTable();

                            GridView2.DataBind();
                        }
                    }
                }
            }
        }
        else
        {
            if (LinkButton3.Text.IndexOf(" (click to show details)") == -1)
            {
                LinkButton3.Text += " (click to show details)";
            }
        }
    }

    protected void DropDownList1_SelectedIndexChanged(object sender, EventArgs e)
    {
        ViewState["TORRENTS_SORT"] = null;

        ViewState["TORRENTS_PAGEINDEX"] = null;

        ViewState["TORRENT_SORT"] = null;

        ViewState["TORRENT_PAGEINDEX"] = null;

        UpdateTorrentList(DropDownList1.SelectedItem.Text, false);

        Timer1.Interval = Convert.ToInt32(DropDownList1.SelectedItem.Value);
    }

    protected void Timer1_Tick(object sender, EventArgs e)
    {
        UpdateTorrentList(DropDownList1.SelectedItem.Text, true);
    }

    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        ViewState["TORRENT_SORT"] = null;

        ViewState["TORRENT_PAGEINDEX"] = null;

        UpdateFileList();
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            if (GridView1.DataKeys[e.Row.RowIndex].Values["Status"].ToString().IndexOf("Started") > -1)
            {
                if (GridView1.DataKeys[e.Row.RowIndex].Values["Status"].ToString().IndexOf("Paused") == -1)
                {
                    e.Row.Cells[1].Text = "<img src='Images/Start_Disabled.png' title='Start' />";
                }
                else
                {
                    e.Row.Cells[2].Text = "<img src='Images/Pause_Disabled.png' title='Pause' />";
                }
            }

            if (GridView1.DataKeys[e.Row.RowIndex].Values["Status"].ToString().IndexOf("Started") == -1)
            {
                if (e.Row.Cells[8].Text == "100%")
                {
                    e.Row.Cells[1].Text = "<img src='Images/Start_Disabled.png' title='Start' />";
                }

                e.Row.Cells[2].Text = "<img src='Images/Pause_Disabled.png' title='Pause' />";
                e.Row.Cells[3].Text = "<img src='Images/Stop_Disabled.png' title='Stop' />";
            }
        }
    }

    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "StartTorrent" || e.CommandName == "PauseTorrent" || e.CommandName == "StopTorrent" || e.CommandName == "DeleteTorrent")
        {
            string hash = Convert.ToString(GridView1.DataKeys[Convert.ToInt32(e.CommandArgument)].Values["Hash"]);

            if (hash.Length > 0)
            {
                UTorrentList torrents = Session["TorrentList"] as UTorrentList;

                if (torrents != null)
                {
                    try
                    {
                        foreach (UTorrent torrent in torrents)
                        {
                            if (hash.Equals(torrent.Hash))
                            {
                                switch (e.CommandName)
                                {
                                    case "StartTorrent":
                                        torrent.Start();

                                        break;
                                    case "PauseTorrent":
                                        torrent.Pause();

                                        break;
                                    case "StopTorrent":
                                        torrent.Stop();

                                        break;
                                    case "DeleteTorrent":
                                        bool deletefiles = Convert.ToBoolean(ConfigurationManager.AppSettings["deletefiles"]);

                                        if (torrent.Progress == 100 && torrent.Remaining == 0)
                                        {
                                            deletefiles = false;
                                        }

                                        torrent.Remove(deletefiles);

                                        ViewState["TORRENT_SORT"] = null;

                                        ViewState["TORRENT_PAGEINDEX"] = null;

                                        GridView2.DataSource = null;
                                        GridView2.DataBind();

                                        LinkButton3.Text = string.Empty;

                                        break;
                                    default:
                                        break;
                                }
                            }
                        }
                    }
                    catch
                    {
                    }

                    torrents.RaiseListChangedEvents = true;

                    torrentsession = Session["TorrentSession"] as TorrentSession;
                    torrentsession.UpdateLists();
                }
            }
        }
    }

    protected void GridView1_Sorting(object sender, GridViewSortEventArgs e)
    {
        string sort = string.Empty;

        if (e.SortExpression != string.Empty)
        {
            sort = e.SortExpression;

            if (Convert.ToString(ViewState["TORRENTS_SORT"]) == sort)
            {
                sort += " DESC";
            }
        }

        ViewState["TORRENTS_SORT"] = sort;

        GridView1.SelectedIndex = -1;

        ViewState["TORRENT_SORT"] = null;

        ViewState["TORRENT_PAGEINDEX"] = null;

        LinkButton3.Text = string.Empty;

        GridView2.DataSource = null;
        GridView2.DataBind();
    }

    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        ViewState["TORRENTS_PAGEINDEX"] = e.NewPageIndex;

        GridView1.SelectedIndex = -1;

        ViewState["TORRENT_SORT"] = null;

        ViewState["TORRENT_PAGEINDEX"] = null;

        LinkButton3.Text = string.Empty;

        GridView2.DataSource = null;
        GridView2.DataBind();
    }

    protected void GridView2_Sorting(object sender, GridViewSortEventArgs e)
    {
        string sort = string.Empty;

        if (e.SortExpression != string.Empty)
        {
            sort = e.SortExpression;

            if (Convert.ToString(ViewState["TORRENT_SORT"]) == sort)
            {
                sort += " DESC";
            }
        }

        ViewState["TORRENT_SORT"] = sort;
    }

    protected void GridView2_Sorted(object sender, EventArgs e)
    {
        UpdateFileList();
    }

    protected void GridView2_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        ViewState["TORRENT_PAGEINDEX"] = e.NewPageIndex;
    }

    protected void GridView2_PageIndexChanged(object sender, EventArgs e)
    {
        UpdateFileList();
    }

    protected void LinkButton1_Click(object sender, EventArgs e)
    {
        Panel5.Visible = true;
        if (ConfigurationManager.AppSettings["uploadlocation"].Length > 0)
        {
            FileUpload1.Enabled = true;
            FileUpload1.ToolTip = string.Empty;
        }
        else
        {
            FileUpload1.Enabled = false;
            FileUpload1.ToolTip = "Populate the uploadlocation appSetting to enable file uploading.";
        }

        DropDownList1.Enabled = false;
        LinkButton1.Enabled = false;
        Timer1.Enabled = false;
        LinkButton2.Enabled = false;
        LinkButton3.Enabled = false;
        CollapsiblePanelExtender1.Enabled = false;
        CollapsiblePanelExtender2.Enabled = false;
        GridView1.Enabled = false;
        GridView2.Enabled = false;
    }

    protected void LinkButton4_Click(object sender, EventArgs e)
    {
        Panel5.Visible = false;
        DropDownList1.Enabled = true;
        LinkButton1.Enabled = true;
        Timer1.Enabled = true;
        LinkButton2.Enabled = true;
        LinkButton3.Enabled = true;
        CollapsiblePanelExtender1.Enabled = true;
        CollapsiblePanelExtender2.Enabled = true;
        GridView1.Enabled = true;
        GridView2.Enabled = true;
        TextBox1.Text = string.Empty;
    }

    protected void LinkButton5_Click(object sender, EventArgs e)
    {
        if (FileUpload1.HasFile)
        {
            FileUpload1.SaveAs(ConfigurationManager.AppSettings["uploadlocation"] + "\\" + FileUpload1.FileName);
        }
        else if (TextBox1.Text.Length > 0)
        {
            torrentsession = Session["TorrentSession"] as TorrentSession;

            torrentsession.StartNewTorrent(TextBox1.Text);
        }

        Panel5.Visible = false;
        DropDownList1.Enabled = true;
        LinkButton1.Enabled = true;
        Timer1.Enabled = true;
        LinkButton2.Enabled = true;
        LinkButton3.Enabled = true;
        CollapsiblePanelExtender1.Enabled = true;
        CollapsiblePanelExtender2.Enabled = true;
        GridView1.Enabled = true;
        GridView2.Enabled = true;
        TextBox1.Text = string.Empty;
    }
</script>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Conditional" RenderMode="Block">
        <ContentTemplate>
            <asp:DropDownList ID="DropDownList1" runat="server" OnSelectedIndexChanged="DropDownList1_SelectedIndexChanged"
                AutoPostBack="True">
                <asp:ListItem Value="3000">All</asp:ListItem>
                <asp:ListItem Selected="True" Value="1500">Downloading</asp:ListItem>
                <asp:ListItem Value="5000">Seeding</asp:ListItem>
                <asp:ListItem Value="10000">Finished</asp:ListItem>
            </asp:DropDownList>
            &nbsp;<asp:LinkButton ID="LinkButton1" runat="server" OnClick="LinkButton1_Click">Add Torrent</asp:LinkButton>
            <br />
            <br />
            <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                    <td width="100%">
                        <asp:Panel ID="Panel1" runat="server">
                            <asp:LinkButton ID="LinkButton2" runat="server" BackColor="#2461BF" Font-Bold="True"
                                ForeColor="White" HorizontalAlign="Left" Width="100%" />
                        </asp:Panel>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Panel ID="Panel2" runat="server">
                            <asp:GridView ID="GridView1" runat="server" OnSelectedIndexChanged="GridView1_SelectedIndexChanged"
                                GridLines="None" CaptionAlign="Left" OnRowDataBound="GridView1_RowDataBound"
                                AutoGenerateColumns="False" DataKeyNames="Hash,Status" AllowSorting="True" OnRowCommand="GridView1_RowCommand"
                                CellPadding="4" ForeColor="#333333" OnSorting="GridView1_Sorting" AllowPaging="True"
                                OnPageIndexChanging="GridView1_PageIndexChanging" EmptyDataText="No Torrents Exist!"
                                EnableSortingAndPagingCallbacks="True">
                                <FooterStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
                                <RowStyle BackColor="#EFF3FB" />
                                <Columns>
                                    <asp:ButtonField Text="Details" CommandName="Select" />
                                    <asp:ButtonField ButtonType="Image" ImageUrl="~/Images/Start_Enabled.png" Text="Start"
                                        CommandName="StartTorrent" />
                                    <asp:ButtonField ButtonType="Image" ImageUrl="~/Images/Pause_Enabled.png" Text="Pause"
                                        CommandName="PauseTorrent" />
                                    <asp:ButtonField ButtonType="Image" ImageUrl="~/Images/Stop_Enabled.png" Text="Stop"
                                        CommandName="StopTorrent" />
                                    <asp:ButtonField ButtonType="Image" ImageUrl="~/Images/Delete.png" Text="Delete"
                                        CommandName="DeleteTorrent" />
                                    <asp:BoundField DataField="Label" HeaderText="Label" SortExpression="Label" Visible="false" />
                                    <asp:BoundField DataField="Name" HeaderText="Name" SortExpression="Name" />
                                    <asp:BoundField DataField="fSize" HeaderText="Size" SortExpression="Size" />
                                    <asp:BoundField DataField="Progress" DataFormatString="{0}%" HeaderText="Progress"
                                        SortExpression="Progress" />
                                    <asp:BoundField DataField="Remaining" HeaderText="Remaining" SortExpression="Remaining"
                                        DataFormatString="{0:g}" Visible="false" />
                                    <asp:BoundField DataField="Downloaded" DataFormatString="{0:g}" HeaderText="Downloaded"
                                        SortExpression="Downloaded" Visible="false" />
                                    <asp:BoundField DataField="Uploaded" DataFormatString="{0:g}" HeaderText="Uploaded"
                                        SortExpression="Uploaded" Visible="false" />
                                    <asp:BoundField DataField="Ratio" DataFormatString="{0:g}" HeaderText="Ratio" SortExpression="Ratio"
                                        Visible="False" />
                                    <asp:BoundField DataField="fDownloadSpeed" HeaderText="Download Speed" SortExpression="DownloadSpeed" />
                                    <asp:BoundField DataField="fUploadSpeed" HeaderText="Upload Speed" SortExpression="UploadSpeed"
                                        Visible="False" />
                                    <asp:BoundField DataField="fETA" HeaderText="ETA" SortExpression="ETA" />
                                    <asp:BoundField DataField="fPeers" HeaderText="Peers" SortExpression="PeersConnected" />
                                    <asp:BoundField DataField="fSeeds" HeaderText="Seeds" SortExpression="SeedsConnected" />
                                    <asp:BoundField DataField="Availability" HeaderText="Availability" SortExpression="Availability" />
                                </Columns>
                                <PagerStyle BackColor="#2461BF" ForeColor="White" HorizontalAlign="Center" />
                                <SelectedRowStyle BackColor="#D1DDF1" Font-Bold="True" ForeColor="#333333" />
                                <HeaderStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" HorizontalAlign="Left" />
                                <EditRowStyle BackColor="#2461BF" />
                                <AlternatingRowStyle BackColor="White" />
                            </asp:GridView>
                        </asp:Panel>
                    </td>
                </tr>
            </table>
            <ajaxToolkit:CollapsiblePanelExtender ID="CollapsiblePanelExtender1" runat="server"
                CollapseControlID="LinkButton2" ExpandControlID="LinkButton2" TargetControlID="Panel2"
                Collapsed="false" SuppressPostBack="true" TextLabelID="LinkButton2">
            </ajaxToolkit:CollapsiblePanelExtender>
            <br />
            <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                    <td width="100%">
                        <asp:Panel ID="Panel3" runat="server">
                            <asp:LinkButton ID="LinkButton3" runat="server" BackColor="#2461BF" Font-Bold="True"
                                ForeColor="White" HorizontalAlign="Left" Width="100%" />
                        </asp:Panel>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Panel ID="Panel4" runat="server">
                            <asp:GridView ID="GridView2" runat="server" GridLines="None" AllowSorting="True"
                                AutoGenerateColumns="False" CaptionAlign="Left" CellPadding="4" ForeColor="#333333"
                                AllowPaging="True" PageSize="10" OnSorting="GridView2_Sorting" OnPageIndexChanging="GridView2_PageIndexChanging"
                                OnSorted="GridView2_Sorted" OnPageIndexChanged="GridView2_PageIndexChanged">
                                <FooterStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
                                <RowStyle BackColor="#EFF3FB" />
                                <Columns>
                                    <asp:BoundField DataField="FileName" HeaderText="FileName" SortExpression="FileName" />
                                    <asp:BoundField DataField="fFileSize" HeaderText="FileSize" SortExpression="FileSize" />
                                    <asp:BoundField DataField="fDownloaded" HeaderText="Downloaded" SortExpression="Downloaded" />
                                    <asp:BoundField DataField="fPercent" HeaderText="Percent" SortExpression="Percent" />
                                    <asp:BoundField DataField="fPriority" HeaderText="Priority" SortExpression="fPriority" />
                                </Columns>
                                <PagerStyle BackColor="#2461BF" ForeColor="White" HorizontalAlign="Center" />
                                <SelectedRowStyle BackColor="#D1DDF1" Font-Bold="True" ForeColor="#333333" />
                                <HeaderStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" HorizontalAlign="Left" />
                                <EditRowStyle BackColor="#2461BF" />
                                <AlternatingRowStyle BackColor="White" />
                            </asp:GridView>
                        </asp:Panel>
                    </td>
                </tr>
            </table>
            <ajaxToolkit:CollapsiblePanelExtender ID="CollapsiblePanelExtender2" runat="server"
                CollapseControlID="LinkButton3" ExpandControlID="LinkButton3" TargetControlID="Panel4"
                SuppressPostBack="true" TextLabelID="LinkButton3">
            </ajaxToolkit:CollapsiblePanelExtender>
            <br />
            <asp:Panel ID="Panel5" runat="server" Visible="False">
                <table>
                    <tr>
                        <td>
                            Add By File
                        </td>
                        <td>
                            <asp:FileUpload ID="FileUpload1" Width="405" Enabled="true" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Add By URL
                        </td>
                        <td>
                            <asp:TextBox ID="TextBox1" Width="400" runat="server"></asp:TextBox>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" ControlToValidate="TextBox1"
                                runat="server" ErrorMessage="*" Display="Dynamic" ValidationExpression="http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&amp;=]*)?">*</asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:LinkButton ID="LinkButton4" runat="server" OnClick="LinkButton4_Click">Cancel</asp:LinkButton>
                        </td>
                        <td>
                            <asp:LinkButton ID="LinkButton5" runat="server" OnClick="LinkButton5_Click">Submit</asp:LinkButton>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="Timer1" EventName="Tick" />
            <asp:AsyncPostBackTrigger ControlID="LinkButton1" EventName="Click" />
            <asp:AsyncPostBackTrigger ControlID="LinkButton2" EventName="Click" />
            <asp:PostBackTrigger ControlID="LinkButton3" />
        </Triggers>
    </asp:UpdatePanel>
    <asp:Timer ID="Timer1" runat="server" Interval="2500" OnTick="Timer1_Tick" Enabled="false" />
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" DisplayAfter="1000">
        <ProgressTemplate>
            <div class="loading">
                <label>
                    &nbsp;Loading...</label>
                <asp:Image ID="LoadingImage" runat="server" ImageUrl="~/Images/Loading.gif" />
                <label>
                    &nbsp;</label>
            </div>
        </ProgressTemplate>
    </asp:UpdateProgress>
</asp:Content>
